<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    CheckStructure()
  ===================================================*/

  function CheckStructure() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form

    // vars messages
    global $msg, $message;

    $message = '';

    // check parent category
    $query  = "select a.category_id, a.name
               from idx_category a
                    left join idx_category b on (a.parent_id = b.category_id)
               where a.parent_id <> 0 
                     and b.category_id is null";
    $result = $dbConn->Execute($query);
    while (!$result->EOF) {
      $cat = $result->Fields('category_id');
      $name = $result->Fields('name');
      $message .= "Parent category not found: <b>(cid=$cat) $name</b><br>";
      $result->MoveNext();
    }
    $result->Close();
    
    // check circle category
    $query  = "select category_id, name
               from idx_category 
               where parent_id <> 0";
    $result = $dbConn->Execute($query);
    while (!$result->EOF) {	
      $cat = $result->Fields('category_id');
      $name = $result->Fields('name');
      $dump = array();
      while (true) {
        $query = "select parent_id, name from idx_category where category_id = '$cat'";
        $row = $dbConn->FetchOne($query);
        $parent_id = $row["parent_id"];
        $name = $row["name"];
        if ($parent_id != 0) {
           if (in_array($parent_id, $dump)) {		    
            $message .= "Incorrect structure at category: <b>(cid=$cat) $name</b><br>";
            break;
          }
          else {
            $dump[] = $parent_id;
            $cat = $parent_id;
          }
        }
        else {
          break;
        }
      }
      unset($dump);
      $result->MoveNext();
    }
    $result->Close();

    if(empty($message)) {
      $message = $msg['20493'];
    }

    DisplayTemplate($admin_template_path . "message.html", "\$message");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  ini_set("max_execution_time", "3600");
  
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  CheckStructure();
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>